/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.system.service.impl;

import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.email.MailInfo;
import com.tp_link.eap.domain.email.MailServer;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.monitor.c.k;
import com.tp_link.eap.monitor.hotspot.service.OperatorServiceI;
import com.tp_link.eap.monitor.system.model.RoleEntry;
import com.tp_link.eap.monitor.system.model.UserModel;
import com.tp_link.eap.monitor.system.model.UserSiteModel;
import com.tp_link.eap.monitor.system.service.a;
import com.tp_link.eap.monitor.system.service.b;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.CSSettingService;
import com.tp_link.eap.user.service.MailServerService;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.user.service.RoleService;
import com.tp_link.eap.user.service.UserService;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="userSettingService")
public class UserSettingServiceImpl
implements b {
    private static final Logger a = LoggerFactory.getLogger(UserSettingServiceImpl.class);
    @Autowired
    private OperatorServiceI b;
    @Autowired
    private UserService c;
    @Autowired
    private RoleService d;
    @Autowired
    private PrivilegeServiceI e;
    @Autowired
    private com.tp_link.eap.monitor.site.service.a f;
    @Autowired
    private a g;
    @Autowired
    private CSSettingService h;
    @Autowired
    private MailServerService i;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a j;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        UserModel userModel = (UserModel)JSONObject.toBean((JSONObject)jSONObject, UserModel.class);
        if (com.tp_link.eap.util.a.e.a((String)userModel.getUserName()) || com.tp_link.eap.util.a.e.a((String)userModel.getRoleId()) || com.tp_link.eap.util.a.e.a((String)userModel.getRoleName()) || com.tp_link.eap.util.a.e.a((String)userModel.getPassword())) {
            a.warn("Invalid request, missing params");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!userModel.getRoleName().equals("administrator") && CollectionUtils.isEmpty(userModel.getSelectSiteList())) {
            a.warn("Please select at least one site.");
            return new OperationResponse(ResErrorCode.cl);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            OperationResponse operationResponse;
            String string2;
            if (this.b.isNameExists(userModel.getUserName())) {
                a.warn("User {} already registered in Hotspot.", (Object)userModel.getUserName());
                return new OperationResponse(ResErrorCode.cm);
            }
            for (String string2 : userModel.getSelectSiteList()) {
                if (this.f.siteNameAlreadyExist(string2)) continue;
                a.warn("Site {} to edit is not exist.", (Object)string2);
                return new OperationResponse(ResErrorCode.r);
            }
            User user = new User();
            user.setName(userModel.getUserName());
            user.setEmail(com.tp_link.eap.util.a.e.a((String)userModel.getEmail()) ? null : userModel.getEmail());
            user.setPassword(userModel.getPassword());
            user.setDefault(false);
            string2 = this.d.getRoleById(userModel.getRoleId());
            user.setRole((Role)string2);
            OperationResponse operationResponse2 = this.c.addUser(user);
            if (!operationResponse2.success()) {
                return operationResponse2;
            }
            if (!userModel.getRoleName().equals("administrator") && !(operationResponse = this.e.refreshUserPrivileges(user.getName(), userModel.getSelectSiteList())).success()) {
                this.c.delUserByName(user.getName(), controlType);
                return operationResponse;
            }
            return operationResponse2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse editUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        UserModel userModel = (UserModel)JSONObject.toBean((JSONObject)jSONObject, UserModel.class);
        if (com.tp_link.eap.util.a.e.a((String)userModel.getUserName()) || com.tp_link.eap.util.a.e.a((String)userModel.getRoleId()) || com.tp_link.eap.util.a.e.a((String)userModel.getRoleName())) {
            a.warn("Invalid request, missing params");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!userModel.getRoleName().equals("administrator") && CollectionUtils.isEmpty(userModel.getSelectSiteList())) {
            a.warn("Please select at least one site.");
            return new OperationResponse(ResErrorCode.cl);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            OperationResponse operationResponse;
            String string2;
            for (String string2 : userModel.getSelectSiteList()) {
                if (this.f.siteNameAlreadyExist(string2)) continue;
                a.warn("Site {} to edit is not exist.", (Object)string2);
                return new OperationResponse(ResErrorCode.r);
            }
            User user = new User();
            user.setName(userModel.getUserName());
            user.setEmail(com.tp_link.eap.util.a.e.a((String)userModel.getEmail()) ? null : userModel.getEmail());
            if (userModel.getPassword() == null) {
                user.setPassword("");
            } else {
                user.setPassword(userModel.getPassword());
            }
            string2 = this.d.getRoleById(userModel.getRoleId());
            user.setRole((Role)string2);
            OperationResponse operationResponse2 = this.c.updateUser(user, false, controlType);
            if (!operationResponse2.success()) {
                return operationResponse2;
            }
            if (!string2.getName().equals("administrator") && !(operationResponse = this.e.refreshUserPrivileges(user.getName(), userModel.getSelectSiteList())).success()) {
                return operationResponse;
            }
            return operationResponse2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse editCurrentUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        UserModel userModel = (UserModel)JSONObject.toBean((JSONObject)jSONObject, UserModel.class);
        if (com.tp_link.eap.util.a.e.a((String)userModel.getUserName()) || com.tp_link.eap.util.a.e.a((String)userModel.getRoleId())) {
            a.warn("Invalid request, missing params");
            return com.tp_link.eap.util.e.aZ;
        }
        User user = new User();
        user.setName(userModel.getUserName());
        user.setEmail(com.tp_link.eap.util.a.e.a((String)userModel.getEmail()) ? null : userModel.getEmail());
        if (userModel.getPassword() == null) {
            user.setPassword("");
        } else {
            user.setPassword(userModel.getPassword());
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            Role role = this.d.getRoleById(userModel.getRoleId());
            user.setRole(role);
            OperationResponse operationResponse = this.c.updateCurrentUser(user);
            return operationResponse;
        }
    }

    @Override
    public OperationResponse getUserSites(ControlType controlType, JSONObject reqObj) {
        Object object;
        Object object2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        List list = null;
        String string = com.tp_link.eap.d.b.a();
        if (controlType.equals((Object)ControlType.b) || controlType.equals((Object)ControlType.d)) {
            object2 = reqObj.optString("cloudUserSessionId");
            if (com.tp_link.eap.util.a.e.a((String)object2)) {
                a.warn("Failed to find sessionId in getCurrentCloudUserInfo");
                return com.tp_link.eap.util.e.aY;
            }
            object = com.tp_link.eap.monitor.cloud.clouduser.a.a.a((String)object2);
            if (com.tp_link.eap.util.a.e.a((String)object)) {
                a.warn("Failed to find accountId for session {}", object2);
                return com.tp_link.eap.util.e.aY;
            }
            list = this.e.getUserPrivileges(com.tp_link.eap.monitor.cloud.e.a.c((String)object));
            if (string == null) {
                a.error("Failed to get current site for cloud user, use last site instead.");
                CloudUser cloudUser = this.j.getCloudUserByAccountId((String)object);
                string = cloudUser.getLastSite();
            }
        } else {
            object2 = jSONObject.optString("userName");
            if (com.tp_link.eap.util.a.e.a((String)object2)) {
                a.warn("Invalid request, missing params");
                return com.tp_link.eap.util.e.aZ;
            }
            list = this.e.getUserPrivileges((String)object2);
            if (string == null) {
                a.error("Failed to get current site for user, use last site instead.");
                object = this.c.getUserByName((String)object2);
                string = object.getLastSite();
            }
        }
        object2 = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudUser cloudUser : list) {
                Site site = this.f.getSiteBySiteName(cloudUser.getSiteName());
                if (site.getSiteName().equals(string)) {
                    site.setLastVisited(true);
                }
                object2.add(site);
            }
        } else {
            a.warn("Failed to find any privileges for user");
        }
        object = new JSONObject();
        object.put((Object)"siteList", object2);
        return new OperationResponse(ResErrorCode.a, object);
    }

    @Override
    public OperationResponse sendResetPwdMail(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("email");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            a.warn("Invalid request, missing email");
            return com.tp_link.eap.util.e.aZ;
        }
        a.debug("Send sendResetPwdMail {}", (Object)string);
        String string2 = this.a();
        String string3 = this.a(string);
        if (string3 == null) {
            a.warn("Email {} has not been registered.", (Object)string);
            return new OperationResponse(ResErrorCode.cw);
        }
        MailInfo mailInfo = new MailInfo(string, string2, string3);
        com.tp_link.eap.util.d.a a2 = new com.tp_link.eap.util.d.a();
        MailServer mailServer = this.i.getMailServer();
        if (mailServer == null || !mailServer.isInitialized() || !mailServer.isSmtpEnable()) {
            a.warn("Email server not set. Please check your settings and try again.");
            return new OperationResponse(ResErrorCode.cF);
        }
        a2.a(mailServer);
        return a2.a(mailInfo);
    }

    @Override
    public OperationResponse logout(ControlType controlType, JSONObject reqObj) {
        if (!controlType.equals((Object)ControlType.c) && !controlType.equals((Object)ControlType.a)) {
            a.warn("logout only support local control");
            return com.tp_link.eap.util.e.bh;
        }
        Subject subject = SecurityUtils.getSubject();
        String string = (String)subject.getPrincipal();
        String string2 = (String)((Object)subject.getSession().getId());
        subject.logout();
        k.a(string, string2);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse getGridUsers(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"name", "roleName"});
        long l2 = this.c.count(grid);
        grid.setTotalRows(l2);
        List list = this.c.getList(grid);
        if (list == null || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<UserModel> arrayList = new ArrayList<UserModel>();
        for (User user : list) {
            UserModel userModel = new UserModel();
            userModel.setUserId(user.getId());
            userModel.setUserName(user.getName());
            userModel.setEmail(user.getEmail());
            userModel.setDescription(user.getDescription());
            userModel.setCreatedTime(simpleDateFormat.format(user.getCreatedTime()));
            userModel.setSysDefault(user.isDefault());
            userModel.setRoleId(user.getRole().getId());
            userModel.setRoleName(user.getRole().getName());
            arrayList.add(userModel);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getLoginState(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        switch (controlType) {
            case c: 
            case a: {
                Subject subject = SecurityUtils.getSubject();
                String string = (String)subject.getPrincipal();
                String string2 = (String)((Object)subject.getSession().getId());
                if (string == null) {
                    hashMap.put("login", false);
                    break;
                }
                boolean bl = !com.tp_link.eap.user.b.a.d((String)string, (String)string2);
                hashMap.put("login", bl);
                break;
            }
            default: {
                String string = reqObj.optString("cloudUserSessionId");
                if (com.tp_link.eap.monitor.cloud.clouduser.a.a.c(string)) {
                    hashMap.put("login", false);
                    break;
                }
                hashMap.put("login", true);
            }
        }
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getCurrentUserInfo(ControlType controlType, JSONObject reqObj) {
        if (!controlType.equals((Object)ControlType.c) && !controlType.equals((Object)ControlType.a)) {
            a.warn("getCurrentUserInfo only support local control");
            return com.tp_link.eap.util.e.bh;
        }
        Subject subject = SecurityUtils.getSubject();
        String string = (String)subject.getPrincipal();
        UserModel userModel = null;
        if (string != null) {
            User user = this.c.getUserByName(string);
            if (user == null) {
                return com.tp_link.eap.util.e.bd;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            userModel = new UserModel();
            userModel.setUserId(user.getId());
            userModel.setUserName(user.getName());
            userModel.setEmail(user.getEmail());
            userModel.setRoleName(user.getRole().getName());
            userModel.setRoleId(user.getRole().getId());
            userModel.setCreatedTime(simpleDateFormat.format(user.getCreatedTime()));
        }
        return new OperationResponse(ResErrorCode.a, userModel);
    }

    @Override
    public OperationResponse getRoleList(ControlType controlType, JSONObject reqObj) {
        List list = this.d.getAll();
        ArrayList<RoleEntry> arrayList = new ArrayList<RoleEntry>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Role role : list) {
            RoleEntry roleEntry = new RoleEntry();
            roleEntry.setId(role.getId());
            roleEntry.setName(role.getName());
            roleEntry.setDescription(role.getDescription());
            roleEntry.setPermission(com.tp_link.eap.util.a.a.a((Set)role.getPermissions()));
            roleEntry.setCreatedTime(simpleDateFormat.format(role.getCreatedTime()));
            arrayList.add(roleEntry);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)hashMap);
    }

    @Override
    public OperationResponse deleteUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("userNames");
        if (jSONArray != null && jSONArray.size() > 0) {
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                String string = jSONArray.getString(i2);
                OperationResponse operationResponse = this.c.delUserByName(string, controlType);
                if (operationResponse.success()) continue;
                return operationResponse;
            }
            return new OperationResponse(ResErrorCode.a, "User was deleted.", null);
        }
        return com.tp_link.eap.util.e.aZ;
    }

    @Override
    public OperationResponse resetPassword(ControlType controlType, JSONObject reqObj) {
        if (controlType != ControlType.a && controlType != ControlType.c) {
            return new OperationResponse(ResErrorCode.g);
        }
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("email", null);
        String string2 = jSONObject.optString("password", null);
        String string3 = jSONObject.optString("verifyCode", null);
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2)) {
            return new OperationResponse(ResErrorCode.cB);
        }
        OperationResult operationResult = this.c.verifyResetPassword(string, string3);
        if (!operationResult.isSuccess()) {
            return new OperationResponse(ResErrorCode.cC);
        }
        a.debug("Reset password email: " + string + ", password: " + string2);
        User user = this.c.getUserByEmail(string);
        if (user != null) {
            user.setPassword(string2);
            user.setVerifyCode("");
            Calendar calendar = Calendar.getInstance();
            user.setVerifyOutDate(calendar.getTime());
            if (this.c.updateUser(user, true, controlType).success() && this.c.updateUserVerifyInfo(user).isSuccess()) {
                return new OperationResponse(ResErrorCode.a, "Reset password successfully.", null);
            }
            return new OperationResponse(ResErrorCode.cB);
        }
        return new OperationResponse(ResErrorCode.cB);
    }

    @Override
    public OperationResponse getSetNewPasswdInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("email", null);
        String string2 = jSONObject.optString("verifyCode", null);
        OperationResult operationResult = this.c.verifyResetPassword(string, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("message", operationResult.getMessage());
        hashMap.put("email", string);
        if (operationResult.isSuccess()) {
            return new OperationResponse(ResErrorCode.a, hashMap);
        }
        return new OperationResponse(ResErrorCode.cC, hashMap);
    }

    @Override
    public OperationResponse checkUserOverLimit(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.c.getUserCounts() >= 50);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getGridUsersWithSites(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"name", "roleName"});
        long l2 = this.c.count(grid);
        grid.setTotalRows(l2);
        List list = this.c.getList(grid);
        if (list == null || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        ArrayList<UserSiteModel> arrayList = new ArrayList<UserSiteModel>();
        for (User user : list) {
            List list2 = this.e.getUserPrivileges(user.getName());
            UserSiteModel userSiteModel = UserSiteModel.convertFromUser(user, list2);
            arrayList.add(userSiteModel);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getCurrentUserWithSites(ControlType controlType, JSONObject reqObj) {
        Subject subject = SecurityUtils.getSubject();
        String string = (String)subject.getPrincipal();
        UserSiteModel userSiteModel = null;
        if (string != null) {
            User user = this.c.getUserByName(string);
            if (user == null) {
                return com.tp_link.eap.util.e.bd;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            userSiteModel = UserSiteModel.convertFromUser(user, simpleDateFormat, this.e.getUserPrivileges(string));
        }
        return new OperationResponse(ResErrorCode.a, userSiteModel);
    }

    private String a() {
        return "[Omada] You requested a new Omada Controller password";
    }

    private String a(String string) {
        Object object;
        String string2 = this.c.generateResetPasswordUrl(string);
        String string3 = this.h.getCSSetting().getHostname();
        if (!l.b() && string3.trim().matches("127\\.0\\.0\\.1|localhost")) {
            object = com.tp_link.eap.util.m.b.f();
            a.debug("Local hosts: " + object.toString());
            string3 = (String)object.get(0);
        }
        object = com.tp_link.eap.configuration.a.a((String)"jetty.properties");
        String string4 = object.getProperty("https.connector.port");
        a.debug("reset url: " + string2 + ", hostname: " + string3 + ", port: " + string4);
        if (string2 == null) {
            return null;
        }
        return "You recently asked to reset your Omada Controller password. To continue, follow this link in 24 hours:\nhttps://" + string3 + ":" + string4 + "/resetpasswd/setnewpasswd?" + string2 + "\n\nDidn't request this change? It' s safe to ignore this email as no change is done upon your account.";
    }
}

